unit ShowGraph01;

interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Dialogs, StdCtrls, ExtCtrls, StrUtils, ComCtrls, MainData, GraphXYv50,
  LeastSquares01, Fourier01;
// ==========================================================
//     
var GraphFuncXY     : TGraphXY;
    GraphSpectr     : TGraphXY;
    GraphBasis      : TGraphXY;

// ==========================================================
procedure Init1ShowGraph01(RqPanelFuncXY, RqPanelSpectr, RqPanelBasis : TPanel);
procedure Init2ShowGraph01(RqCDialog      : TColorDialog;
                           RqCLamp1Aprox  : TStaticText;
                           RqCLamp2Aprox  : TStaticText;
                           RqCLampTFunc   : TStaticText;
                           RqCLampBasis   : TStaticText;
                           RqFuncSScript  : TComboBox;
                           RqSpectrSScipt : TComboBox;
                           RqLViewBasis   : TListView);
//-----------------------------------------------------------
procedure CloseShowGraph01();
// ==========================================================
//      
function  GetColorInDialog(RqCDialog : TColorDialog): TColor;
//-----------------------------------------------------------
//      
procedure ALLGraphClean();
//-----------------------------------------------------------
//       
procedure FuncGraphClean();
//       
procedure SpectrGraphClean();
//       
procedure BasisGraphClean();
//-----------------------------------------------------------
//       
procedure SetFuncColorDialog (RqInd  : integer);
//-----------------------------------------------------------
//        
//    .
procedure TabXYDotPaintToGFunc(RqTable : TGraphArr);
//        
//    BASIS.
procedure TabXYDotPaintToGBasis(RqTable : TGraphArr);
//-----------------------------------------------------------
//     - 
procedure LinePaintTablePointXY(RqTable : TGraphArr);
//-----------------------------------------------------------
//      
procedure ShowSpectr(RqTable : array of extended; RqColor : TColor);
// ==========================================================
//     Basis 
procedure SetBasisColorDialog();
//-----------------------------------------------------------
//    BasisSelectList    ListView
procedure ChangeBasisSelectList (RqItem: TListItem);
//-----------------------------------------------------------
//    
//    
procedure ShowBasisDetalAproxFunc
    (RqSelectKoeff : boolean; RqDetal, RqMethod, RqSeries : word);
// ==========================================================
//         JPEG
// IdGraph : F -     
//           S -  
//           V -       
procedure SaveSelectGraphicAsJPEG(IdGraph : char; SDialog : TSaveDialog);

// ==========================================================
// IMPLEMENTATION BEGIN
// ==========================================================
implementation

// ==========================================================
//    UNIT
// ==========================================================

// ==========================================================
//    UNIT
// ==========================================================

var CtrlCDialog      : TColorDialog;
    CtrlCLamp1Aprox  : TStaticText;
    CtrlCLamp2Aprox  : TStaticText;
    CtrlCLampTFunc   : TStaticText;
    CtrlCLampBasis   : TStaticText;
    CtrlFuncSScript  : TComboBox;
    CtrlSpectrSScipt : TComboBox;
    CtrlLViewBasis   : TListView;

// ==========================================================
//   UNIT
// ==========================================================
// ==========================================================
//  / 
// ==========================================================
// ----------------------------------------------------------
//
//    UNIT ShowGraph01
//   
procedure Init1ShowGraph01(RqPanelFuncXY, RqPanelSpectr, RqPanelBasis : TPanel);
begin
    if GraphFuncXY = nil
    then begin
      //     
      GraphFuncXY := TGraphXY.Create(RqPanelFuncXY);
      // 
      GraphFuncXY.GraphTitul:='     ';
      GraphFuncXY.BackGroundColor := RGB(200,200,200);
    end;
    if GraphSpectr = nil
    then begin
      //     
      GraphSpectr := TGraphXY.Create(RqPanelSpectr);
      GraphSpectr.RulerEnabled := False;
      // 
      GraphSpectr.GraphTitul:='   ()';
      GraphSpectr.BackGroundColor := RGB(200,200,200);
      //      
      GraphSpectr.PicAxesX   := '';
    end;
    if GraphBasis = nil
    then begin
      //     
      GraphBasis := TGraphXY.Create(RqPanelBasis);
      // 
      GraphBasis.GraphTitul:='  '
         + '   .';
      GraphBasis.BackGroundColor := RGB(200,200,200);
    end;
end;
// ----------------------------------------------------------
//
//    UNIT ShowGraph01
procedure CloseShowGraph01();
begin
   if GraphFuncXY <> nil
   then begin
     GraphFuncXY.Free;
   end;
   if GraphSpectr <> nil
   then begin
      GraphSpectr.Free;
   end;
   if GraphBasis <> nil
   then begin
      GraphBasis.Free;
   end;
end;
// ----------------------------------------------------------
//
//    UNIT ShowGraph01
//    . 
procedure Init2ShowGraph01(RqCDialog      : TColorDialog;
                           RqCLamp1Aprox  : TStaticText;
                           RqCLamp2Aprox  : TStaticText;
                           RqCLampTFunc   : TStaticText;
                           RqCLampBasis   : TStaticText;
                           RqFuncSScript  : TComboBox;
                           RqSpectrSScipt : TComboBox;
                           RqLViewBasis   : TListView);
begin
   //       
   CtrlCDialog      := RqCDialog;
   CtrlCLamp1Aprox  := RqCLamp1Aprox;
   CtrlCLamp2Aprox  := RqCLamp2Aprox;
   CtrlCLampTFunc   := RqCLampTFunc;
   CtrlCLampBasis   := RqCLampBasis;
   CtrlFuncSScript  := RqFuncSScript;
   CtrlSpectrSScipt := RqSpectrSScipt;
   CtrlLViewBasis   := RqLViewBasis;
   //       
   TableFuncionColor := clWhite;  //   
   AproximationColor := clBlue;   //  
   BasisColor        := clGreen;  //    
   //   
   CtrlCLamp1Aprox.Color := AproximationColor;
   CtrlCLamp2Aprox.Color := AproximationColor;
   CtrlCLampTFunc.Color  := TableFuncionColor;
   CtrlCLampBasis.Color  := BasisColor;
   //    
   //     
   while CtrlFuncSScript.Items.Count > 0 do CtrlFuncSScript.Items.Delete(0);
   CtrlFuncSScript.Items.Add('   ');
   CtrlFuncSScript.Items.Add('   ');
   CtrlFuncSScript.Items.Add('    X');
   CtrlFuncSScript.Items.Add('    Y');
   CtrlFuncSScript.ItemIndex := 0;
end;

// ==========================================================
//  
// ==========================================================
// ----------------------------------------------------------
// 02.10.2008
//      
function GetColorInDialog(RqCDialog : TColorDialog): TColor;
begin
 GetColorInDialog := clBtnFace;
 if RqCDialog.Execute
 then begin
   GetColorInDialog := RqCDialog.Color;
 end;
end; // of procedure

// ==========================================================
//   
// ==========================================================
// ----------------------------------------------------------
// 10.10.2008
//       
procedure FuncGraphClean();
begin
  if GraphFuncXY <> nil
  then  GraphFuncXY.FullEraseAreaXY();
end; // of procedure
// ----------------------------------------------------------
// 10.12.2008
//       
procedure SpectrGraphClean();
begin
  if GraphSpectr <> nil
  then GraphSpectr.FullEraseAreaXY();
end; // of procedure
// ----------------------------------------------------------
// 13.12.2008
//       
procedure BasisGraphClean();
begin
  if GraphBasis <> nil
  then GraphBasis.FullEraseAreaXY();
end; // of procedure
// ----------------------------------------------------------
// 12.10.2008
//      
procedure ALLGraphClean();
begin
     FuncGraphClean();
     SpectrGraphClean();
     BasisGraphClean();
end; // of procedure
// ==========================================================
//   UNIT
// ==========================================================
// ----------------------------------------------------------
//
//       
procedure SetFuncColorDialog (RqInd  : integer);
var  WColor : TColor;
begin
   //   
   WColor := GetColorInDialog(CtrlCDialog);
   case RqInd of
       0 : begin //      
             TableFuncionColor := WColor;
             CtrlCLampTFunc.Color  := WColor;
           end;
       1 : begin //      
             AproximationColor := WColor;
             CtrlCLamp1Aprox.Color := WColor;
             CtrlCLamp2Aprox.Color := WColor;
           end;
   end;
end;
// ==========================================================
//       
// ==========================================================
// ----------------------------------------------------------
//
//        
procedure TableFuncXYDotPaint
         (RqGraphic : TGraphXY; RqTable : TGraphArr;
          RqColor : TColor; RqSubScript : char);
var Ind    : word;
    WX, WY : extended;
begin
 if RqGraphic <> nil
 then begin
   if Length(RqTable) > 2
   then begin

      if not((RqGraphic.ReadScaleX > 0) and (RqGraphic.ReadScaleY > 0))
      then  RqGraphic.FindOptimalScale(RqTable);

      for Ind:= Low(RqTable) to High(RqTable) do
      begin
        WX := RqTable[Ind].X;
        WY := RqTable[Ind].Y;
        RqGraphic.PaintPointXY(WX, WY, {clBlack,} RqColor,2);
        case UpCase(RqSubScript) of
            // N -  
            // X -  X
            // Y -  Y
           'N' : RqGraphic.SubscriptPointXY(WX,WY,RGB(0,64,0),IntToStr(Ind));
           'X' : RqGraphic.SubscriptPointXY(WX,WY,RGB(0,64,0),FloatToStr(WX));
           'Y' : RqGraphic.SubscriptPointXY(WX,WY,RGB(0,64,0),FloatToStr(WY));
        end;
      end;
   end;
 end;
end;

// ----------------------------------------------------------
//
//        
//    .
procedure TabXYDotPaintToGFunc(RqTable : TGraphArr);
var SubScript : char;
begin
  SubScript := ' ';
  if Length(RqTable) > 2
  then begin
    case CtrlFuncSScript.ItemIndex of
       1 : SubScript := 'N';
       2 : SubScript := 'X';
       3 : SubScript := 'Y';
    end;
    TableFuncXYDotPaint(GraphFuncXY, RqTable, TableFuncionColor, SubScript);
  end;
end; // of procedure

// ----------------------------------------------------------
//
//        
//    BASIS.
procedure TabXYDotPaintToGBasis(RqTable : TGraphArr);
begin
  if Length(RqTable) > 2
  then begin
    TableFuncXYDotPaint(GraphBasis, RqTable, TableFuncionColor, '-');
  end;
end; // of procedure

// ==========================================================
//      
// ==========================================================
// ----------------------------------------------------------
//
//     - 
procedure LinePaintTablePointXY(RqTable : TGraphArr);
var WCl : TColor;
begin
  if Length(RqTable) > 2
  then begin
    // --------------------------------------
    //   
    WCl:= AproximationColor;
    GraphFuncXY.ShowGraphXY(RqTable, WCl);
    // --------------------------------------
  end;
end;

// ==========================================================
//  
// ==========================================================
// ----------------------------------------------------------
//
//       
procedure ShowSpectr(RqTable : array of extended; RqColor : TColor);
const cBlankArea  = 0.1;
var Ind             : word;
    YMax, YMin, Yd  : extended;
    XB, YB, XE, YE  : extended;
begin
 if (GraphSpectr <> nil) and (Length(RqTable) > 0)
 then begin
      //     
      YMax := 0;
      YMin := 0;
      for Ind:= Low(RqTable) to High(RqTable) do
      begin
          if RqTable[Ind] > YMax then YMax := RqTable[Ind];
          if RqTable[Ind] < YMin then YMin := RqTable[Ind];
      end;
      // --------------------------------------------
      if (YMax > YMin)
      then begin
         //       X
         if (YMax = 0) //    
         then begin
             //      X
             YMax := cBlankArea * abs(YMin);
         end;
         if (YMin = 0) //    
         then begin
             //      X
             YMin := - cBlankArea * abs(YMax);
         end;
         if (YMax > 0) and (YMin <0 ) //   
         then begin
             //       
             Yd  := cBlankArea * (YMax - YMin);
             YMax := YMax + Yd;
             YMin := YMin - Yd;
         end;

         if not ((GraphSpectr.ReadScaleX > 0) and (GraphSpectr.ReadScaleY > 0))
         then begin
           //   (     )
           GraphSpectr.SetMinMaxXY
               (Low(RqTable)-1, High(RqTable)+ 1, YMin, YMax);
         end;
         
         //  
         YB := 0;
         for Ind:= Low(RqTable) to High(RqTable) do
         begin
           XB := Ind;
           XE := Ind;
           YE := RqTable[Ind];
           GraphSpectr.VectotToGraphXY(XB, YB, XE, YE, RqColor);
           //        
           //     
           GraphSpectr.SubscriptPointXY(XB, YB, RqColor, IntToStr(Ind));
           case CtrlSpectrSScipt.ItemIndex of
             //    
             1 : GraphSpectr.SubscriptPointXY
                 (XE, YE, RqColor, FloatToStr(RqTable[Ind]) );

           end; // of case
         end;
      end;
 end;
end;

// ==========================================================
//     
// ==========================================================
// ----------------------------------------------------------
//
//     Basis 
procedure SetBasisColorDialog();
begin
   //   
   BasisColor := GetColorInDialog(CtrlCDialog);
   CtrlCLampBasis.Color  := BasisColor;
end;
// ----------------------------------------------------------
//
//    BasisSelectList    ListView
procedure ChangeBasisSelectList (RqItem: TListItem);
var Ind : integer;
begin
  if Length (BasisSelectList) > 0
  then begin
     Ind := RqItem.Index;
     if (Ind >= Low(BasisSelectList)) and (Ind <= High(BasisSelectList))
     then BasisSelectList[Ind]:= RqItem.Checked
     else RqItem.Checked := False;
  end;
end; // of procedure

// ----------------------------------------------------------
//
//    (Series)      
function  GetBasisSeriesValue
   (RqSelectKoeff : boolean; RqMethod, RqSeries : word; RqX : extended):extended;
begin
 GetBasisSeriesValue := 0;
 case RqMethod of
   cmLSquares : begin  //    
       GetBasisSeriesValue := BasisCalcPolinom
                             (RqSelectKoeff, RqSeries, LSquaresKoeff, RqX );
   end;
   cmFourier : begin   //   
      case RqSeries of
        //       ,
        cfFourierAB : begin
          GetBasisSeriesValue := BasisCalcFourierFuncAB(RqSelectKoeff, RqX);
        end;
      end; // of case RqSeries
   end;
 end; // of case RqMethod
end; // of function

// -----------------------------------------------------
//
//    
//    
procedure ShowBasisDetalAproxFunc
    (RqSelectKoeff : boolean; RqDetal, RqMethod, RqSeries : word);
var DetalAproxFuncTAB : TGraphArr;
    Ind               : word;
    Period, WX, WY    : extended;
begin
 if (LastExecuteMethod > 0) and (LastExecuteSeries > 0)
 then begin
      Period := TableFuncionArray[High(TableFuncionArray)].X
              - TableFuncionArray[Low(TableFuncionArray)].X;
      //   
      SetLength(DetalAproxFuncTAB, RqDetal);
      for Ind := Low(DetalAproxFuncTAB) to High(DetalAproxFuncTAB) do
      begin
         //    
         WX := TableFuncionArray[Low(TableFuncionArray)].X
             + (Period / RqDetal) * Ind ;
         WY := GetBasisSeriesValue(RqSelectKoeff, RqMethod, RqSeries, WX);
         DetalAproxFuncTAB[Ind].X:= WX;
         DetalAproxFuncTAB[Ind].Y:= WY;
      end;
      //    .
      GraphBasis.ShowGraphXY(DetalAproxFuncTAB, BasisColor);

 end;
end; // of procedure

// ==========================================================
//     JPEG
// ==========================================================
// ----------------------------------------------------------
//  12.10.2008
//     
procedure SaveGraphicAsJPEG (IdGraph : char; FullFileName : string);
begin
   // 'J' -  jpg, 'B' -  bmp.
   case UpCase(IdGraph) of
     // --------------------------------
     //    
     'F' : GraphFuncXY.SaveGraphXY(FullFileName, 'J');
     // --------------------------------
     // 
     'S' : GraphSpectr.SaveGraphXY(FullFileName, 'J');
     // --------------------------------
     //      
     'V' : GraphBasis.SaveGraphXY(FullFileName, 'J');
     // --------------------------------
   end;
end;

//-----------------------------------------------------------
//
//         JPEG
// IdGraph : F -     
//           S -  
//           V -       
procedure SaveSelectGraphicAsJPEG(IdGraph : char; SDialog : TSaveDialog);
var FullFileName, ShortFileName : string;
begin
    SDialog.Title := '  ...';
    SDialog.Filter:='Graphics files (*.jpg)|*.jpg';
    if SDialog.Execute
    then begin
      FullFileName := Trim(SDialog.FileName);
      if UpperCase(RightStr(FullFileName,4)) <> '.JPG'
      //    (  )  
      then begin
         FullFileName := FullFileName + '.jpg';
      end;
      //    
      ShortFileName:= ExtractFileName(FullFileName);

      if FileExists(FullFileName)
      then begin
        if MessageDlg( ': ' + ShortFileName + #13#10
                      + ' ' + #13#10
                      + '   ?',
                         mtWarning, [mbYes, mbNo], 0) = mrYes
        then begin
            //      .
            SaveGraphicAsJPEG (IdGraph, FullFileName);
        end;
      end
      else begin
         //      .
         SaveGraphicAsJPEG (IdGraph, FullFileName);
      end; // of FileExists(SDialog.FileName)
    end; // of FileExists(SDialog.FileName)
end; // of procedure

// ==========================================================
// IMPLEMENTATION END
// ==========================================================

end.
